--> pralable
-- USE BD_Air_France;

-- sous requtes

SELECT SUM(pil_hvol) AS "Total"
FROM   T_pilote_pil
WHERE  pil_chef IN 
(SELECT pil_brevet
 FROM   T_pilote_pil 
 WHERE  cmp_comp = 
 (SELECT cmp_comp
  FROM   T_compagnie_cmp
  WHERE  cmp_nom = 'Air France'));

/* inquijoin */

CREATE TABLE T_heures_Vol_thv
(thv_titre CHAR(20), thv_bas DECIMAL(10,2), thv_haut DECIMAL(10,2));

INSERT INTO T_heures_Vol_thv VALUES ('Novice',0,500);
INSERT INTO T_heures_Vol_thv VALUES ('Niveau 1',500,1000);
INSERT INTO T_heures_Vol_thv VALUES ('Niveau 2',1000,5000);


SELECT p1.pil_brevet, p1.pil_nom, p1.pil_hvol, p2.pil_hvol "Rfrence"
FROM   T_pilote_pil p1
JOIN   T_pilote_pil p2 ON p1.pil_hvol > p2.pil_hvol
WHERE  p2.pil_brevet = 'PL-2';

/* relationnelle */

SELECT p1.pil_brevet, p1.pil_nom, p1.pil_hvol, p2.pil_hvol "Rfrence"
FROM   T_pilote_pil p1, T_pilote_pil p2
WHERE  p1.pil_hvol > p2.pil_hvol
AND    p2.pil_brevet = 'PL-2';


SELECT p.pil_brevet, p.pil_nom, p.pil_hvol, v.thv_titre
FROM   T_pilote_pil p
JOIN   T_heures_Vol_thv v 
ON     (p.pil_hvol > v.thv_bas AND p.pil_hvol <= v.thv_haut);

/* relationnelle */

SELECT p.pil_brevet, p.pil_nom, p.pil_hvol, v.thv_titre
FROM   T_pilote_pil p, T_heures_Vol_thv v
WHERE  p.pil_hvol > v.thv_bas 
AND    p.pil_hvol <= v.thv_haut;

-- sous requte pas possible

DROP TABLE T_heures_Vol_thv;
DROP TABLE T_pilote_pil;
DROP TABLE T_compagnie_cmp;

/* externes */


CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_pays CHAR(3), cmp_nom VARCHAR(15),
 CONSTRAINT pk_compagnie PRIMARY KEY(cmp_comp));

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6), pil_prenom VARCHAR(15), pil_nom VARCHAR(15), 
 pil_hvol DECIMAL(7,2), cmp_comp VARCHAR(4), 
 CONSTRAINT pk_pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp));

CREATE TABLE T_qualifs_qlf
(pil_brevet VARCHAR(6), qlf_avi CHAR(4), qlf_valide DATE,
 CONSTRAINT fk_qlf_pil FOREIGN KEY(pil_brevet) REFERENCES T_pilote_pil(pil_brevet));

INSERT INTO T_compagnie_cmp VALUES ('AF', 'fr', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING','sn', 'Singapore AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL');

INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Lamothe', 450, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Didier','Linxe', 900, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Michel','Castaings', 1000, 'SING');
INSERT INTO T_pilote_pil VALUES ('PL-4', 'Henri','Alqui', 3400, 'AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A320','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A340','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-2', 'A320','20160404');
INSERT INTO T_qualifs_qlf VALUES ('PL-3', 'A330','20160513');

/* R7 */

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_compagnie_cmp c
LEFT OUTER JOIN T_pilote_pil p 
ON              p.cmp_comp  = c.cmp_comp ;

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM             T_pilote_pil p
RIGHT OUTER JOIN T_compagnie_cmp c
ON               p.cmp_comp  = c.cmp_comp ;


SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM    T_pilote_pil p, T_compagnie_cmp c
WHERE   p.cmp_comp  =* c.cmp_comp ;


/* R8 */


SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_pilote_pil p 
LEFT OUTER JOIN T_qualifs_qlf q 
ON              p.pil_brevet = q.pil_brevet;

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_qualifs_qlf q
RIGHT OUTER JOIN T_pilote_pil p 
ON              p.pil_brevet = q.pil_brevet;


INSERT INTO T_pilote_pil VALUES ('PL-5', 'Pascal','Larrazet', 1500,NULL);

DELETE FROM T_qualifs_qlf 
WHERE pil_brevet = 'PL-4' 
AND   qlf_avi = 'A340';

ALTER TABLE T_qualifs_qlf  DROP CONSTRAINT fk_qlf_pil;

INSERT INTO T_qualifs_qlf  VALUES ('PL-7', 'A380','20170708');

/* R9 */

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_compagnie_cmp c
FULL OUTER JOIN T_pilote_pil p 
ON              p.cmp_comp  = c.cmp_comp;

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_pilote_pil p 
FULL OUTER JOIN T_compagnie_cmp c
ON              p.cmp_comp  = c.cmp_comp;

/* R10 */

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_qualifs_qlf q
FULL OUTER JOIN T_pilote_pil p 
ON              p.pil_brevet = q.pil_brevet;

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_pilote_pil p 
FULL OUTER JOIN T_qualifs_qlf q 
ON              p.pil_brevet = q.pil_brevet;


DROP TABLE T_qualifs_qlf;
GO

DROP TABLE T_heures_Vol_thv;
GO

DROP TABLE T_pilote_pil;
GO

DROP TABLE T_compagnie_cmp;
GO
